/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.server;

import Twofish.Twofish_Algorithm;
import filenet.vw.api.VWException;
import filenet.vw.server.VWConvertTwoB;

public final class VWConvertTwoE
extends VWConvertTwoB {
    protected String getEString(String astr) throws VWException {
        double dvalue = 0.0;
        int value = 0;
        if (astr == null || astr.length() < 1) {
            return null;
        }
        try {
            dvalue = Math.round(Math.random() * (double)(this.kcnt - 1));
            value = (int)dvalue;
            if (value <= 0 || value > this.kcnt - 1) {
                value = 1;
            }
        }
        catch (Exception xx) {
            throw new VWException("vw.server.VWConvertBadKount", "Bad Count {0}", xx.getMessage());
        }
        return this.getEString(astr, value);
    }

    private String getEString(String astr, int value) throws VWException {
        String baseStr = null;
        try {
            int i;
            Object key = Twofish_Algorithm.makeKey(this.entryk(value).getBytes());
            byte[] strBytes = astr.getBytes("UTF8");
            int j = strBytes.length;
            int rem = j % 16;
            int padLen = 0;
            if (rem != 0) {
                padLen = 16 - rem;
            }
            byte[] in = new byte[j + padLen];
            for (i = 0; i < j; ++i) {
                in[i] = strBytes[i];
            }
            for (i = 0; i < padLen; ++i) {
                in[j++] = 1;
            }
            String tokenStr = null;
            String blockStr = "\\";
            int blockcount = 0;
            byte[] in1 = new byte[16];
            float insize = in.length / 16;
            int b = 0;
            while (insize > (float)b) {
                byte[] eBytes = Twofish_Algorithm.blockEncrypt(in, b * 16, key);
                baseStr = VWConvertTwoE.encode(eBytes);
                blockStr = b == 0 ? baseStr : blockStr + "\\" + baseStr;
                ++blockcount;
                ++b;
            }
            tokenStr = value + "\\" + blockcount + "\\" + blockStr + "\\";
            baseStr = VWConvertTwoE.encode(tokenStr);
        }
        catch (Exception xx) {
            throw new VWException("vw.server.VWConvertBadString", "Bad String {0} {1}", xx.getMessage(), new Integer(value));
        }
        return baseStr;
    }

    private static String encode(String data) throws Exception {
        byte[] byteData = data.getBytes("UTF8");
        return VWConvertTwoE.encode(byteData);
    }

    private static String encode(byte[] data) throws Exception {
        int len = data.length;
        StringBuffer ret = new StringBuffer((len / 3 + 1) * 4);
        for (int i = 0; i < len; ++i) {
            int c = data[i] >> 2 & 0x3F;
            ret.append(cvt.charAt(c));
            c = data[i] << 4 & 0x3F;
            if (++i < len) {
                c |= data[i] >> 4 & 0xF;
            }
            ret.append(cvt.charAt(c));
            if (i < len) {
                c = data[i] << 2 & 0x3F;
                if (++i < len) {
                    c |= data[i] >> 6 & 3;
                }
                ret.append(cvt.charAt(c));
            } else {
                ++i;
                ret.append((char)fillchar);
            }
            if (i < len) {
                c = data[i] & 0x3F;
                ret.append(cvt.charAt(c));
                continue;
            }
            ret.append((char)fillchar);
        }
        return ret.toString();
    }
}

